.386P
.MODEL FLAT,C

_TEXT SEGMENT DWORD PUBLIC 'CODE'
        ASSUME CS:_TEXT,DS:_DATA

; - interface ---------------------------------------------------------------
public  DrawString_ASM

public  DrawWormHole_ASM
extrn   wormholetable: dword
extrn   motionblurtable: byte
extrn   angleadder:byte,distanceadder:byte,angleadder2:byte,distanceadder2:byte

public  DrawZoomer_ASM
extrn   zoomerstart,zoomerdelta

public  DrawMiniPicture_ASM

public  FadeFrameBuffer_ASM
public  CrossFadeFrameBuffer_ASM
extrn   shadetable:byte

public  DrawFlyEye_ASM

public  DrawBlurredImage_ASM

public  DrawLogo_ASM
extrn   logodata:byte

public  BlinkFrameBuffer_ASM

public  PolarizeBitmap_ASM
extrn   polartable:byte
extrn   angleadder:byte,distanceadder:byte,angleadder2:byte,distanceadder2:byte
extrn   polaroffset2
extrn   polaroffset3

public  DrawBump_ASM
extrn   Phongmap:byte

public  DrawStripes_ASM

; - implementacio -----------------------------------------------------------

; - string rajzolo mag ------------------------------------------------------
cadder            dd ?
intensity         db ?

DrawString_ASM      PROC NEAR
                    ; parameterek: EBX -> string
                    ;              EDI:= destptr, ESI:= fontptr,
                    ;              ECX:= X, EDX:= Y

                    push ebp
                    mov [intensity],al
                    mov ebp,ebx
                    imul edx,320
                    shl ecx,2
                    shl edx,2
                    add edi,ecx
                    add edi,edx                 ; EDI:= destptr + 4*(320*Y + X)

NxtChar:            movzx ecx,byte ptr [ebp]    ; soron kovetkezo karakter
                    or cl,cl
                    jz StringEnd                ; ha sztringvege jelet kap

                    cmp cl,' '
                    jne NotSpace
                    inc ebp
                    add edi,4*6                 ; 6 pixel szeles space
                    jmp NxtChar

NotSpace:           push edi                    ; videoptr elmentese
                    sub cl,'a'                  ; indexre konvertalas
                    imul ecx,181                ; egy karakter merete [byte]

                    mov eax,320
                    sub al,byte ptr [esi + ecx]
                    shl eax,2
                    mov [cadder],eax            ; cadder:= 4*(320 - szelesseg)

                    mov bh,13                   ; konstans karaktermagassag
                    mov edx,ecx
                    inc edx                     ; EDX -> data
NxtRow:             mov bl,byte ptr [esi + ecx] ; EDX:= szelesseg
NxtPixel:           mov al,byte ptr [esi + edx]
                    or al,al
                    jz Transparent              ; a 0-as pixel atlatszo
                    and al,[intensity]
                    mov ah,al
                    shl eax,8
                    mov al,ah
                    mov dword ptr [edi],eax
Transparent:        inc edx
                    add edi,4                   ; kovetkezo pixel
                    dec bl
                    jnz NxtPixel
                    add edi,[cadder]
                    dec bh
                    jnz NxtRow

                    pop edi                     ; videoptr visszakerese
                    inc ebp                     ; kovetkezo karakter
                    movzx eax,byte ptr [esi + ecx]
                    add eax,2
                    shl eax,2
                    add edi,eax                 ; EDI:= oldvideoptr + 4*(szelesseg + 2)
                    jmp NxtChar

StringEnd:          pop ebp
                    ret

DrawString_ASM      ENDP

; - wormhole rajzolo mag ----------------------------------------------------
DrawWormHole_ASM    PROC NEAR
                   ; parameterek: EDI:= destptr, ESI:= srcptr, EAX:= srcptr2,
                   ;              ECX:= kezdo tablabejegyzes

                   push ebp
                   xor ebx,ebx
                   mov ebp,eax
                   xor edx,edx
                   xor ecx,ecx

pNxtPix:           mov dx,word ptr wormholetable[ecx] ; U a DH-ba, V a DL-be!
                   mov bx,dx
                   add dh,[distanceadder]
                   add bh,[distanceadder2]
                   add dl,[angleadder] ; EDX:= 4*(256*distance + angle)
                   add bl,[angleadder2] ; EBX:= 4*(256*distance2 + angle2)

                   movzx eax,byte ptr [esi + 4*edx + 0] ; B1 be
                   add al,byte ptr [ebp + 4*ebx + 0] ; B2 be
                   adc ah,0
                   shl eax,7 ; AH= B_new
                   mov al,byte ptr [edi]
                   mov al,motionblurtable[eax] ; AL= B_blur
                   mov byte ptr [edi],al ; B ki

                   movzx eax,byte ptr [esi + 4*edx + 1] ; G1 be
                   add al,byte ptr [ebp + 4*ebx + 1] ; G2 be
                   adc ah,0
                   shl eax,7 ; AH= G_new
                   mov al,byte ptr [edi + 1]
                   mov al,motionblurtable[eax] ; AL= G_blur
                   mov byte ptr [edi + 1],al ; G ki

                   movzx eax,byte ptr [esi + 4*edx + 2] ; R1 be
                   add al,byte ptr [ebp + 4*ebx + 2] ; R2 be
                   adc ah,0
                   shl eax,7 ; AH= R_new
                   mov al,byte ptr [edi + 2]
                   mov al,motionblurtable[eax] ; AL= R_blur
                   mov byte ptr [edi + 2],al ; R ki

                   add edi,4 ; kovetkezo pixel
                   add ecx,2
                   cmp ecx,2*320*180
                   jbe pNxtPix

                   pop ebp
                   ret

DrawWormHole_ASM    ENDP

; - texturazoomer mag -------------------------------------------------------
zoomery dd 0

DrawZoomer_ASM     PROC NEAR
                   ; parameterek: EDI:= destptr, ESI:= srcptr

                   push ebp
                   xor ebx,ebx ; fixpontos szamlalok uritese
                   mov ecx,[zoomerstart]
                   mov [zoomery],180

zNxtRow:           mov ebp,320
                   add ecx,[zoomerdelta] ; ECX+= dY
                   mov edx,[zoomerstart]
zNxtPix:           add edx,[zoomerdelta] ; EDX+= dX
                   mov bh,ch ; offset-te alakitas
                   mov bl,dh

                   mov ah,byte ptr [edi] ; B_old be
                   mov al,byte ptr [esi + 4*ebx] ; B_new be
                   and eax,0FFh
                   mov al,motionblurtable[eax]
                   mov byte ptr [edi],al ; B ki
                   mov ah,byte ptr [edi + 1] ; G_old be
                   mov al,byte ptr [esi + 4*ebx + 1] ; G_new be
                   and eax,0FFh
                   mov al,motionblurtable[eax]
                   mov byte ptr [edi + 1],al ; G ki
                   mov ah,byte ptr [edi + 2] ; R_old be
                   mov al,byte ptr [esi + 4*ebx + 2] ; R_new be
                   and eax,0FFh
                   mov al,motionblurtable[eax]
                   mov byte ptr [edi + 2],al ; G ki

                   add edi,4 ; kovetkezo pixel
                   dec ebp
                   jnz zNxtPix
                   dec [zoomery]
                   jnz zNxtRow

                   pop ebp
                   ret

DrawZoomer_ASM     ENDP

; - keretezett/nagyitott kiskep kirako --------------------------------------
DrawMiniPicture_ASM     PROC NEAR
                   ; parameterek: EDI:= destptr, ESI:= srcptr

                   mov eax,0FFFFFFFFh
                   mov ecx,2*33
                   rep stosd
                   add edi,4*(320 - 2*33 + 1)

                   mov ch,32
mNxtRow:           mov cl,32
                   mov dword ptr [edi - 4],0FFFFFFFFh ; feher baloldali keret
                   mov dword ptr [edi + 4*(320 - 1)],0FFFFFFFFh ; feher baloldali keret

mNxtPix:           lodsb ; pixel be
                   mov ah,al
                   shl eax,8
                   mov al,ah

                   mov dword ptr [edi],eax ; pixel ki
                   mov dword ptr [edi + 4],eax
                   mov dword ptr [edi + 4*320],eax
                   mov dword ptr [edi + 4*321],eax

                   add edi,4*2
                   dec cl ; kovetkezo pixel
                   jnz mNxtPix

                   mov dword ptr [edi],0FFFFFFFFh ; feher jobboldali keret
                   mov dword ptr [edi + 4*320],0FFFFFFFFh ; feher jobboldali keret
                   add edi,4*(2*320 - 2*32); kovetkezo sor
                   dec ch
                   jnz mNxtRow

                   ; also keret megrajzolasa
                   sub edi,4 ; feher
                   mov eax,0FFFFFFFFh
                   mov ecx,2*33
                   rep stosd

                   ret

DrawMiniPicture_ASM     ENDP

; - kepernyo fader mag ------------------------------------------------------
FadeFrameBuffer_ASM       PROC NEAR
                ; parameter: EDI -> framebuffer, ESI -> shadetable,
                ;            EAX:= factor

                shl eax,8
                xor ebx,ebx
                xor edx,edx
                mov bh,ah
                mov dh,ah ;AH:= BH:= DH:= fadefactor
                mov ecx,320*180
NxtFPix:        mov al,byte ptr [edi] ; B be
                mov bl,byte ptr [edi + 1] ;  G be
                mov dl,byte ptr [edi + 2] ;  R be
                mov al,byte ptr [esi + eax]
                mov bl,byte ptr [esi + ebx]
                mov dl,byte ptr [esi + edx]
                mov byte ptr [edi],al ; B ki
                mov byte ptr [edi + 1],bl ; G ki
                mov byte ptr [edi + 2],dl ; R ki
                add edi,4 ; kovetkezo pixel
                dec ecx
                jnz NxtFPix

                ret

FadeFrameBuffer_ASM       ENDP

; - kepernyo crossfader mag -------------------------------------------------
factor  db 0

CrossFadeFrameBuffer_ASM    PROC NEAR

                ; parametek: EDI:= destptr, ESI:= srcptr,
                ;            EBX:= shadetable, EDX:= factor;

                push ebp
                mov ebp,320*180

                shl eax,8
                mov [factor],ah
                xor ebx,ebx
                xor ecx,ecx
                xor edx,edx
                mov dh,ah ; DH:= factor
                xor dh,255 ; AH:= (255 - factor)

iNxtPix:        mov ah,[factor] ; AH:= factor
                mov bh,[factor] ; BH:= factor
                mov ch,[factor] ; CH:= factor
                mov al,byte ptr [edi] ; B1 be
                mov bl,byte ptr [edi + 1] ; G1 be
                mov cl,byte ptr [edi + 2] ; R1 be
                mov al,shadetable[eax] ; AL:= B1 factor arnyalatban
                mov bl,shadetable[ebx] ; BL:= G1 factor arnyalatban
                mov cl,shadetable[ecx] ; CL:= R1 factor arnyalatban

                mov dl,byte ptr [esi] ; B2
                add al,shadetable[edx] ; AL:= B1 factor arnyalatban + B2 (255 - factor) arnyalatban
                mov dl,byte ptr [esi + 1] ; G2 be
                add bl,shadetable[edx] ; BL:= G1 factor arnyalatban + G2 (255 - factor) arnyalatban
                mov dl,byte ptr [esi + 2] ; R2 be
                add cl,shadetable[edx] ; CL:= R1 factor arnyalatban + R2 (255 - factor) arnyalatban

                mov byte ptr [edi],al ; pixel ki
                mov byte ptr [edi + 1],bl
                mov byte ptr [edi + 2],cl

                add edi,4 ; kovetkezo pixel
                add esi,4
                dec ebp
                jnz iNxtPix

                pop ebp
                ret

CrossFadeFrameBuffer_ASM    ENDP

; - legyszem-effekt rajzolo mag ---------------------------------------------
spotsprite db    0,  32,  64,  32,   0 ; folt
           db   32, 128, 192, 128,  32
           db   64, 192, 224, 192,  64
           db   32, 128, 192, 128,  32
           db    0,  32,  64,  32,   0

flypixel1       dd ?
flypixel2       dd ?

DrawFlyEye_ASM     PROC NEAR

                   push ebp
                   mov dh,18 ; sorok szama

eNxtSpotRow:       push edi ; pointer elmentese
                   mov dl,32 ; egy sorban levo foltok

eNxtSpot:          push edi ; pointer elmentese

                   mov ch,5 ; folt magassaga
                   mov ebp,offset spotsprite
                   mov esi,offset spotsprite
                   mov eax,dword ptr [edi]
                   mov [flypixel1],eax ; flypixel1:= felso_pixelertek
                   mov eax,dword ptr [edi + 4*(5*320 + 5)]
                   mov [flypixel2],eax ; flypixel2:= also_pixelertek

eNxtRow:           mov cl,5 ; folt szelessege
eNxtPix:           mov al,byte ptr [ebp] ; maszkertek
                   mov bl,byte ptr [esi] ; maszkertek
                   or al,al
                   jz eNoDrawUpper
                   mov eax,[flypixel1] ; pixel be
                   mov dword ptr [edi],eax ; pixel ki

eNoDrawUpper:      or bl,bl
                   jz eNoDrawDowner
                   mov eax,[flypixel2] ; pixel be
                   mov dword ptr [edi + 4*(5*320 + 5)],eax ; pixel ki

eNoDrawDowner:     add edi,4 ; kovetkezo pixel
                   inc ebp
                   inc esi
                   dec cl
                   jnz eNxtPix
                   add edi,4*(320 - 5) ; kovetkezo sor
                   dec ch
                   jnz eNxtRow

                   pop edi ; kovetkezo folt
                   add edi,4*10
                   dec dl
                   jnz eNxtSpot

                   pop edi ; kovetkezo foltsor
                   add edi,4*320*10
                   dec dh
                   jnz eNxtSpotRow

                   pop ebp
                   ret

DrawFlyEye_ASM     ENDP

; - blur-olt animacio kirako rutin magja ------------------------------------
DrawBlurredImage_ASM    PROC NEAR

                   mov ecx,320*180
                   xor eax,eax

bNxtPix:           movzx eax,byte ptr [esi] ; P_old be
                   mov ah,byte ptr [edi] ; R_new be
                   mov al,byte ptr motionblurtable[eax]
                   mov ah,al ; pixel kiegeszitese
                   shl eax,8
                   mov al,ah
                   stosd ; pixel ki

                   add esi,4 ; kovetkezo pixel
                   dec ecx
                   jnz bNxtPix
                   ret

DrawBlurredImage_ASM    ENDP

; - logo es kiskep rajzolo mag ----------------------------------------------
LOGOPICTURE_WIDTH       EQU 214

DrawLogo_ASM    PROC NEAR

                mov ch,147 ; logo magassaga
                lea esi,logodata + 3*16 ; pixeldata-ra pozicionalas
                xor eax,eax ; pixeltarolok uritese
                xor edx,edx

lNxtRow:        mov cl,LOGOPICTURE_WIDTH/2 ; logo szelessegenek fele
lNxtPix:        lodsb
                mov dl,al
                and al,0F0h ; pixelek kimaszkolasa
                and dl,00Fh
                shr al,4
                imul eax,3 ; palettaoffszetek szamitasa
                imul edx,3

                mov bl,byte ptr [logodata + eax + 0] ; R1 be
                mov byte ptr [edi + 2],bl ; R1 ki
                mov bl,byte ptr [logodata + eax + 1] ; G1 be
                mov byte ptr [edi + 1],bl ; G1 ki
                mov bl,byte ptr [logodata + eax + 2] ; B1 be
                mov byte ptr [edi + 0],bl ; B1 ki

                mov bl,byte ptr [logodata + edx + 0] ; R2 be
                mov byte ptr [edi + 4 + 2],bl ; R2 ki
                mov bl,byte ptr [logodata + edx + 1] ; G2 be
                mov byte ptr [edi + 4 + 1],bl ; G2 ki
                mov bl,byte ptr [logodata + edx + 2] ; B2 be
                mov byte ptr [edi + 4 + 0],bl ; B2 ki

                add edi,2*4
                dec cl ; kovetkezo pixel
                jnz lNxtPix
                add edi,4*(320 - LOGOPICTURE_WIDTH)
                dec ch
                jnz lNxtRow

                ret

DrawLogo_ASM    ENDP

; - villantas ---------------------------------------------------------------
BlinkFrameBuffer_ASM   PROC NEAR
                ; parametek: EDI:= destptr, ESI:= srcptr, EDX:= factor

                mov ecx,320*180
                shl eax,8
                mov ebx,eax
                xor bh,0FFh ; BH:= factor XOR 0xFF

fNxtPix:        mov al,byte ptr [edi] ; B be
                mov bl,al
                xor bl,0FFh
                mov dl,shadetable[eax] ; DL:= shadetable[intensity][factor]
                add dl,shadetable[ebx]
                mov byte ptr [edi],dl

                mov al,byte ptr [edi + 1] ; G be
                mov bl,al
                xor bl,0FFh
                mov dl,shadetable[eax] ; DL:= shadetable[intensity][factor]
                add dl,shadetable[ebx]
                mov byte ptr [edi + 1],dl

                mov al,byte ptr [edi + 2] ; B be
                mov bl,al
                xor bl,0FFh
                mov dl,shadetable[eax] ; DL:= shadetable[intensity][factor]
                add dl,shadetable[ebx]
                mov byte ptr [edi + 2],dl

                add edi,4 ; kovetkezo pixel
                dec ecx
                jnz fNxtPix

                ret

BlinkFrameBuffer_ASM  ENDP

; - bitmappolarizalo mag ----------------------------------------------------
polarx          dw ?
polary          dw ?

PolarizeBitmap_ASM    PROC NEAR
                ; parameterek: EDI:= destptr, EAX:= tableoffsetadder,
                ;              ESI:= srcptr, ECX:= srcptr2

                push ebp
                mov ebp,eax ; EBP:= tableoffsetadder
                xor eax,eax
                xor edx,edx

                mov [polary],180
oNxtLin:        mov [polarx],320
oNxtPix:        movzx ebx,word ptr polartable[ebp] ; texturakoordinatak betoltese
                push ebp
                mov ebp,[polaroffset2]
                add bh,polartable[ebp]
                add bl,polartable[ebp + 1]
                mov ebp,[polaroffset3]
                add bh,polartable[ebp]
                add bl,polartable[ebp + 1]
                pop ebp
                and ebx,0FFFFh

                mov dx,bx
                add bh,[distanceadder2]
                add dh,[distanceadder]
                add bl,[angleadder2] ; EBX:= 4*(256*distance2 + angle2)
                add dl,[angleadder] ; EDX:= 4*(256*distance + angle)

                mov al,byte ptr [esi + 4*edx + 0] ; B1 be
                mov ah,byte ptr [ecx + 4*ebx + 0] ; B2 be
                mov ah,motionblurtable[eax]
                mov al,byte ptr [edi + 0] ; B_old be
                mov al,motionblurtable[eax]
                mov byte ptr [edi + 0],al ; B ki

                mov al,byte ptr [esi + 4*edx + 1] ; G1 be
                mov ah,byte ptr [ecx + 4*ebx + 1] ; G2 be
                mov ah,motionblurtable[eax]
                mov al,byte ptr [edi + 1] ; G_old be
                mov al,motionblurtable[eax]
                mov byte ptr [edi + 1],al ; G ki

                mov al,byte ptr [esi + 4*edx + 2] ; R1 be
                mov ah,byte ptr [ecx + 4*ebx + 2] ; R2 be
                mov ah,motionblurtable[eax]
                mov al,byte ptr [edi + 2] ; R_old be
                mov al,motionblurtable[eax]
                mov byte ptr [edi + 2],al ; R ki

                add edi,4 ; kovetkezo pixel
                add ebp,2
                add [polaroffset2],2
                add [polaroffset3],2
                dec [polarx]
                jnz oNxtPix

                add ebp,2*(520 - 320); kovetkezo sor
                add [polaroffset2],2*(520 - 320)
                add [polaroffset3],2*(520 - 320)
                dec [polary]
                jnz oNxtLin

                pop ebp
                ret

PolarizeBitmap_ASM    ENDP

; - texturazott bump mag ----------------------------------------------------
bumpx           dw ?
bumpy           db ?

DrawBump_ASM    PROC NEAR
                ; parameterek: EDI:= destptr, ESI:= srcptr, EDX:= lightsource_adder

                xor eax,eax
                xor ebx,ebx

                add esi,4*320 ; also es felso sor kimarad
                add edi,4*320
                mov [bumpy],179
uNxtLin:        mov [bumpx],320
uNxtPix:        movzx ebx,[bumpx] ; torzitas kiszamitasa G komponens alapjan
                shr bx,1
                add bl,byte ptr [esi - 4 + 1]
                sub bl,byte ptr [esi + 4 + 1] ; BL:= dX + (x>>1)
                mov bh,[bumpy]
                shr bh,1
                add bh,byte ptr [esi - 4*320 + 1]
                sub bh,byte ptr [esi + 4*320 + 1] ; BH:= dY + (y>>1)
                add bx,dx ;fenyforras kezdopoziciojanak hozzadasa
                movzx bx,byte ptr phongmap[ebx] ; BL:= fenyesseg

                movzx ax,byte ptr [esi + 0]; B be
                add al,bl
                jnc uNoTruncB
                mov al,255
uNoTruncB:      mov byte ptr [edi + 0],al ; B ki

                movzx ax,byte ptr [esi + 1]; G be
                add al,bl
                jnc uNoTruncG
                mov al,255
uNoTruncG:      mov byte ptr [edi + 1],al ; G ki

                movzx ax,byte ptr [esi + 2]; R be
                add al,bl
                jnc uNoTruncR
                mov al,255
uNoTruncR:      mov byte ptr [edi + 2],al ; B ki

                add esi,4 ; kovetkezo pixel
                add edi,4
                dec [bumpx]
                jnz uNxtPix

                dec [bumpy] ; kovetkezo sor
                jnz uNxtLin

                ret

DrawBump_ASM    ENDP

; - shaded csik rajzolo mag -------------------------------------------------
DrawStripes_ASM PROC NEAR

                xor eax,eax ; pixeltarolo uritese

                mov ebx,180
aNxtLin:        xor edx,edx
aNxtPix:        mov ah,255 ; 60- shade: 255
                cmp edx,60
                ja aLOK
                mov ah,240 ; 40-60 shade: 240
                cmp edx,40
                ja aLOK
                mov ah,200 ; 20-40 shade: 180
                cmp edx,20
                ja aLOK
                mov ah,150 ; -20 shade: 130
aLOK:           cmp edx,320 - 60
                jb aROK
                mov ah,240
                cmp edx,320 - 40
                jb aROK
                mov ah,200
                cmp edx,320 - 20
                jb aROK
                mov ah,150

aROK:           mov al,byte ptr [edi] ; B be
                mov al,shadetable[eax]
                mov byte ptr [edi],al ; B ki

                mov al,byte ptr [edi + 1] ; G be
                mov al,shadetable[eax]
                mov byte ptr [edi + 1],al ; G ki

                mov al,byte ptr [edi + 2] ; R be
                mov al,shadetable[eax]
                mov byte ptr [edi + 2],al ; R ki

                add edi,4 ; kovetkezo pixel
                inc edx
                cmp edx,320
                jne aNxtPix

                dec ebx ; kovetkezo sor
                jnz aNxtLin

                ret

DrawStripes_ASM ENDP

_TEXT ENDS

END
